<?php
ini_set('display_errors', '0');
ini_set('soap.wsdl_cache_enabled', '1');
require "defs.php";

$id = null;
$uid = null;
$partner = null;
$partnerMail = null;
$partnerContact = null;
$partnerAddress = null;
$partnerZip = null;
$partnerCity = null;
$partnerTextOptional = null;
$partnerTel = null;
$partnerFax = null;
$partnerTheme = null;
$partnerNavi = null;
$partnerShowPrint = null;
$partnerFreiText = null;

$sess_id = sess_id;

$page = $_GET["page"];
if (isset($_GET["uid"]) || isset($_GET["action"])) {
    $uid = isset($_GET["uid"]) ? $_GET["uid"] : $_GET["action"];
}

if(!$uid){
	$uid = isset($_SESSION["uid"]) ? $_SESSION["uid"] : null;
}

$db = new SQLite3(partnerDB);

$errorText = "";
if (isset($uid)) {		
		$partnerRes = $db->query("SELECT id,uid,firma,email,ansprechpartner, ansprechpartner_alt, funktion, funktion_alt,freitext, strasse,plz,ort,optional,telefon,fax,theme,navi,showPrint,click,active FROM customers WHERE uid='".$db->escapeString($uid)."'");
		$partnerRow = $partnerRes->fetchArray(SQLITE3_ASSOC);

		if($partnerRow["active"] != 1){
			$errorText =  "uid ist nicht freigegeben";
		}

		if (!empty($partnerRow)) {
			$id = $partnerRow["id"];		
			$uid = $partnerRow["uid"];
			$_SESSION["uid"] = $uid;
			$partner = $partnerRow["firma"];
			$partnerMail = $partnerRow["email"];
			$partnerContact = ( $partnerRow["ansprechpartner_alt"] )? $partnerRow["ansprechpartner_alt"] : $partnerRow["ansprechpartner"];
			$partnerFunktion = ( $partnerRow["funktion_alt"] )? $partnerRow["funktion_alt"] : $partnerRow["funktion"];
			$partnerAddress = $partnerRow["strasse"];
			$partnerZip = $partnerRow["plz"];
			$partnerCity = $partnerRow["ort"];
			$partnerTextOptional = $partnerRow["optional"];
			$partnerTel = $partnerRow["telefon"];
			$partnerFax = $partnerRow["fax"];
			$partnerTheme = $partnerRow["theme"];
			$partnerNavi = json_decode($partnerRow["navi"]);
			$partnerFreiText = $partnerRow["freitext"];
			$partnerShowPrint = $partnerRow["showPrint"];
			$newclick =  intval($partnerRow["click"]) + 1;
			
			$partnerRes = $db->query("Update customers set click = ".$newclick." WHERE uid='".$uid."'");
		} else {
			$errorText = "uid ist nicht existiert"; 
		}
}else{
	$errorText = "Bitte starten Sie die Anwendung mit den richtigen Parameter neu"; 
}

$news = [];
$newsRes = $db->query("SELECT id, title, date, subheadline, alt_text, text, image_credit FROM news WHERE active = 1");
while ($row = $newsRes->fetchArray(SQLITE3_ASSOC)) {
  $news[] = $row;
}


$js[]="function MM_openBrWindow(theURL,winName,features, myWidth, myHeight, isCenter) { //v3.0
	if(window.screen)if(isCenter)if(isCenter==\"true\"){
		var myLeft = (screen.width-myWidth)/2;
		var myTop = (screen.height-myHeight)/2;
		features+=(features!='')?',':'';
		features+=',left='+myLeft+',top='+myTop;
	}
	window.open(theURL,winName,features+((features!='')?',':'')+'width='+myWidth+',height='+myHeight);
}";

							 
if($page=="Ueber-Uns"  || $page=="") $pageContent = "content-blocks/ueber-uns.php";

if($page=="Immobilien") $pageContent = "content-blocks/immobilien.php";

if($page=="Aktuelles") $pageContent = "content-blocks/aktuelles.php";
if($page=="Details") $pageContent = "content-blocks/details.php";
if($page=="Neubau") $pageContent = "content-blocks/neubau.php";
if($page=="Hauskauf") $pageContent = "content-blocks/hauskauf.php";
if($page=="Modernisierung") $pageContent = "content-blocks/modernisierung.php";
if($page=="Sanierungsbegleitung-Fenstertausch") $pageContent = "content-blocks/sanierungsbegleitung-fenstertausch.php";
if($page=="Sanierungsbegleitung-Aussenwanddaemmung") $pageContent = "content-blocks/sanierungsbegleitung-aussenwanddaemmung.php";
if($page=="Sanierungsbegleitung-Dachdaemmung") $pageContent = "content-blocks/sanierungsbegleitung-dachdaemmung.php";
if($page=="Sanierungsbegleitung-Effizienzhaus") $pageContent = "content-blocks/sanierungsbegleitung-effizienzhaus.php";
if($page=="Sanierungsbegleitung-Heizung") $pageContent = "content-blocks/sanierungsbegleitung-heizung.php";


if($page=="Heizung") $pageContent = "content-blocks/heizung.php";
if($page=="Foerdergeldservice-Heizungsmodernisierung") $pageContent = "content-blocks/foerdergeldservice-heizungsmodernisierung.php";

if($page=="Foerdermoeglichkeiten") $pageContent = "content-blocks/foerdermoeglichkeiten.php";
if($page=="Kontakt") $pageContent = "content-blocks/kontakt.php";

if($page=="Energieberater") $pageContent = "content-blocks/energieberater.php";
if($page=="Initialberatung") $pageContent = "content-blocks/initialberatung.php";
if($page=="Sanierungsfahrplan") $pageContent = "content-blocks/sanierungsfahrplan.php";
if($page=="Energieausweis") $pageContent = "content-blocks/energieausweis.php";
if($page=="Thermografie") $pageContent = "content-blocks/thermografie.php";
if($page=="Luftdichtheitsmessung") $pageContent = "content-blocks/luftdichtheitsmessung.php";

if($page=="BAFA-Vor-Ort-Beratung") $pageContent = "content-blocks//bafa-vor-ort-beratung.php";


if($page=="Energiesparrechner") $pageContent = "content-blocks/energiesparrechner.php";


if($page=="Energiesparfilme") $pageContent = "content-blocks/energiesparfilme.php";
if($page=="Impressum") $pageContent = "content-blocks/impressum.php";
if($page=="Datenschutz") $pageContent = "content-blocks/datenschutz.php";

$noFooterKontakt = array('Kontakt','Impressum','Datenschutz');
$onload[]="window.location.href = '#top';";

//$errorText = "";


echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de" lang="de">
<head>
<?php if (!empty($partner)): ?>
	<title>Fördermittelauskunft - <?php echo ucfirst($partner);?></title>
<?php else: ?>
	<title>Fördermittelauskunft</title>
<?php endif; ?>
<meta charset="UTF-8" />
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="robots" content="index, follow" />	
<meta name="febis-questionizer-config-url" content="https://questionizer.foerdermittelauskunft.de/de/starpool/client-config.json" />
<style>
:root {
  --primary-color: <?php echo $partnerTheme ? $partnerTheme : '#9E0100'; ?>;
}
</style>
<link rel="stylesheet" href="css/awesome/css/font-awesome.css" />
<link href="css/bootstrap.min.css" rel="stylesheet">
  
<link rel="stylesheet" type="text/css" href="font.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.1.0/cookieconsent.min.js"></script>
<script>
window.addEventListener("load", function () {
  window.cookieconsent.initialise({
    palette: {
      popup: {
        background: "#000"
      },
      button: {
        background: "<?php echo $partnerTheme;?>",
        text: "#fff"
      }
    },
    content: {
      message: "Diese Website verwendet nur funktional notwendige Cookies. Mehr Informationen ...",
      dismiss: "Verstanden",
      link: "Datenschutz",
      href: "index.php?page=Datenschutz"
    },
    elements: {
      popup: '<div role="dialog" aria-label="Cookiehinweis" class="cc-window {{classes}}">{{message}}{{compliance}}</div>',
      dismiss: '<button type="button" class="cc-btn cc-dismiss" aria-label="Verstanden">{{dismiss}}</button>'
    },
    onInitialise: function () {
      const btn = document.querySelector('.cc-dismiss');
      if (btn) btn.focus(); // optional für Tastatur
    }
  });
});
</script>

</head>
<body >
  <?php if(!$errorText): ?> 
	<a class="visually-hidden-focusable" href="#main-content">Zum Hauptinhalt springen</a>
	<!-- BARRIEREFREIES LAYOUT -->
	<div id="page-wrapper">
		<div role="banner">
		<?php include('header.php'); ?>
		</div>

		<main id="main-content" role="main" tabindex="-1">
		<?php include($pageContent); ?>
		</main>

		<div role="contentinfo">
			<?php include('footer.php'); ?>
		</div>
	</div>

	<!-- Session ID -->
	<?php echo hidden_sess_id; ?>
	<?php else: ?>
		<main id="main-content" role="main" tabindex="-1">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<p class="mb-4">&nbsp;</p>
						<p class="mb-4">&nbsp;</p>
						<div class="text-center">
							<div class="alert alert-dark" role="alert">
								<h2>Die Partner-Anbindung kann leider nicht gestartet werden</h2>
								<h4> <?php echo $errorText ?></h4>
							</div>
						</div>
					</div>

				</div>
			</div>
		</main>
	<?php endif; ?>
</body>
<script src="js/bootstrap.bundle.min.js"></script>

</html>

