<?php
ini_set('display_errors', '0');

// PDO-Datenbankverbindung
try {
    $db = new PDO('sqlite:' . __DIR__ . '/admin/data/database.sqlite');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    http_response_code(500);
    exit("Datenbankfehler");
}

// UID validieren
$uid = isset($_GET['uid']) ? $_GET['uid'] : '';
if (!$uid) {
    header("HTTP/1.1 400 Bad Request");
    exit("Ungültige UID");
}

// Abfrage vorbereiten und ausführen
$stmt = $db->prepare("SELECT logo, logo_mime_type, ansprechpartner FROM customers WHERE uid = :uid AND active = 1");
$stmt->execute([':uid' => $uid]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row && !empty($row['logo'])) {
    $imageData = $row['logo'];
    $mimeType = $row['logo_mime_type'] ?? 'image/png';

    if (in_array($mimeType, ['image/jpeg', 'image/png', 'image/gif', 'image/webp'])) {
        ob_clean();
        header("Content-Type: $mimeType");
        header("Content-Length: " . strlen($imageData));

        $stream = fopen('php://memory', 'r+');
        fwrite($stream, $imageData);
        rewind($stream);
        fpassthru($stream);
        fclose($stream);
        exit;
    }
}

// Fallback-Grafik anzeigen
header("Content-Type: image/png");
readfile(__DIR__ . "/pix/kein-bild.png");
exit;