<div class="mt-4">&nbsp;</div>

<?php if (!in_array($page, $noFooterKontakt)): ?>

  <!-- Kontaktbereich -->
  <section aria-labelledby="kontakt-ueberschrift" class="py-4">
    <div class="container">
      <h1 id="kontakt-ueberschrift" class="text-center"><?php echo htmlspecialchars($partner); ?> ist für Sie da</h1>
      <h2 class="h3 text-center" style="margin-top: 0;">Wir beraten Sie gern persönlich.</h2>

      <div class="row mt-4" role="list" aria-label="Kontaktinformationen">

        <!-- Ansprechpartner -->
        <article class="col-md-4 text-center mb-4" role="listitem">
          <i class="fa fa-user" aria-hidden="true" style="color: var(--primary-color); font-size: 4em;"></i>
          <h2 class="h4 mt-3"><?php echo ($partnerContact); ?></h2>
          <address>
            <?php echo htmlspecialchars($partnerAddress); ?><br />
            <?php echo htmlspecialchars($partnerZip); ?>&nbsp;<?php echo htmlspecialchars($partnerCity); ?>
          </address>
        </article>

        <!-- E-Mail & Kontaktformular -->
        <article class="col-md-4 text-center mb-4" style="border-left: 1px solid #000; border-right: 1px solid #000;" role="listitem">
          <i class="fa fa-at" aria-hidden="true" style="color: var(--primary-color); font-size: 4em;"></i>
          <h2 class="h4 mt-3">
            <a href="mailto:<?php echo htmlspecialchars($partnerMail); ?>" aria-label="E-Mail an <?php echo htmlspecialchars($partnerContact); ?>">
              <?php echo htmlspecialchars($partnerMail); ?>
            </a>
          </h2>
          <a href="Kontakt" class="btn btn-warning mt-3" aria-label="Zum Kontaktformular">
            <i class="fa fa-arrow-right" aria-hidden="true"></i> zum Kontaktformular
          </a>
        </article>

        <!-- Telefon -->
        <article class="col-md-4 text-center mb-4" role="listitem">
          <i class="fa fa-phone" aria-hidden="true" style="color: var(--primary-color); font-size: 4em;"></i>
          <h2 class="h4 mt-3">
            <a href="tel:<?php echo htmlspecialchars($partnerTel); ?>" aria-label="Telefonnummer <?php echo htmlspecialchars($partnerTel); ?>">
              <?php echo htmlspecialchars($partnerTel); ?>
            </a>
          </h2>
          <?php if (!empty($partnerFax)): ?>
            <p>Fax: <?php echo htmlspecialchars($partnerFax); ?></p>
          <?php endif; ?>
          <?php if (!empty($partnerFreiText)): ?>
            <?php echo ($partnerFreiText); ?>
          <?php endif; ?>
        </article>

      </div>
    </div>
  </section>

<?php endif; ?>

<div class="mt-4">&nbsp;</div>
<div class="mt-4">&nbsp;</div>

<!-- Footer -->
<footer class="footer bg-grey py-4" role="contentinfo">
  <div class="container">
    <div class="row align-items-center">

      <!-- Logo -->
      <div class="col-md-6 mb-3 mb-md-0">
        <a href="." class="d-inline-block" aria-label="Zur Startseite">												
				  <img class="logo" style="border-width:0px;" alt="Logo" title="logo" src="pix/logo-starpool.png">							
			  </a>	
      </div>

      <!-- Navigation -->
      <div class="col-md-6 text-md-end">
        <nav aria-label="Footer-Navigation">
          <ul class="list-inline mb-0">
            <li class="list-inline-item me-2">
              <a href="Impressum" title="Impressum">Impressum</a>
            </li>
            <li class="list-inline-item">
              <a href="Datenschutz" title="Datenschutz">Datenschutz</a>
            </li>
          </ul>
        </nav>
      </div>

    </div>
  </div>
</footer>
