<!-- Einführung -->
<section class="py-5" aria-labelledby="sanierungsfahrplan-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="sanierungsfahrplan-ueberschrift" class="text-uppercase">Individueller Sanierungsfahrplan</h1>
        <h3>Staatlich geförderte Energieberatung zu Energieeinsparung, Kosten und Förderung.</h3>
      </div>
    </div>
  </div>
</section>

<!-- Beratungsdetails -->
<section class="bg-grey py-5" aria-labelledby="beratung-details">
  <div class="container" id="beratung-details">
    <div class="row">
      <!-- Linke Spalte -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/energieberater.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbol Energieberater">
        </div>
        <h3 class="text-center"><strong>Staatlich geförderte Beratung</strong></h3>
        <p>Sie planen eine Modernisierung des Eigenheims? Lassen Sie sich über einen individuellen Sanierungsfahrplan (iSFP) aufzeigen, welche energetischen Maßnahmen sinnvoll und lohnend sind.</p>
        <p>Die Beratungskosten werden im Rahmen der Bundesförderung für Energieberatung für Wohngebäude mit 50&nbsp;% bezuschusst, maximal 650&nbsp;&euro; im Ein- und Zweifamilienhaus.</p>
      </div>

      <!-- Mittlere Spalte -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/checkliste.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbol Checkliste">
        </div>
        <h3 class="text-center"><strong>Sanierungsfahrplan im Überblick</strong></h3>
        <ul>
          <li>Datenaufnahme durch einen Energieeffizienz-Experten</li>
          <li>Analyse von Gebäudehülle und Haustechnik</li>
          <li>Einblick in Baupläne, Heizkosten, Schornsteinfegerprotokoll</li>
          <li>Auswertung und Berechnung der Einsparpotentiale</li>
          <li>Berücksichtigung bereits umgesetzter Modernisierungen</li>
          <li>Vorschläge zu Maßnahmen und Investitionskosten</li>
          <li>Angabe möglicher Förderprogramme</li>
          <li>Ergebnisreport inklusive Maßnahmenübersicht</li>
        </ul>
      </div>

      <!-- Rechte Spalte -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/rueckruf.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbol Rückrufservice">
        </div>
        <h3 class="text-center"><strong>Sanierungsfahrplan anfordern</strong></h3>
        <p>Fordern Sie Ihre persönliche Beratung einfach per Hotline oder Kontaktformular an. Wir vermitteln einen Energieberater in Ihrer Nähe.</p>
        <p>Hotline (kostenlos):</p>
        <h3 class="text-center"><strong><i class="fa fa-phone" style="color: #9E0100;"></i>&nbsp;06190 9263-487</strong></h3>
        <p class="text-center">Werktags von 9&nbsp;&ndash;&nbsp;17&nbsp;Uhr</p>
        <div class="text-center">
          <a href="https://foerderdata.de/isfp-starpool/" target="_blank" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Beratung hier anfordern</strong>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Schritte zur Umsetzung -->
<section class="py-5" aria-labelledby="umsetzungs-schritte">
  <div class="container" id="umsetzungs-schritte">
    <div class="row">
      <div class="col-12 text-center">
        <h1>Professionelle Energieberater</h1>
      </div>
    </div>

    <div class="row mt-3">
      <div class="col-md-2"></div>
      <div class="col-md-8 text-center">
        <p>Für maximale Energieeinsparung und optimale Fördermöglichkeiten arbeiten wir mit unabhängigen, qualifizierten Energieberater:innen zusammen.</p>
      </div>
      <div class="col-md-2"></div>
    </div>

    <div class="row mt-4">
      <!-- Schritt 1 -->
      <div class="col-md-4">
        <h3><strong>Schritt 1</strong></h3>
        <ul>
          <li>Unverbindliche Anfrage über das Formular</li>
          <li>Start des Sanierungsfahrplans erst nach Angebotsbestätigung</li>
          <li>Beantragung des Beratungszuschusses durch uns</li>
        </ul>
      </div>

      <!-- Schritt 2 -->
      <div class="col-md-4 border-start border-end">
        <h3><strong>Schritt 2</strong></h3>
        <ul>
          <li>Gebäudeanalyse durch einen Experten</li>
          <li>Erstellung Ihres individuellen Fahrplans</li>
          <li>Übergabe inkl. Abschlussgespräch</li>
        </ul>
      </div>

      <!-- Schritt 3 -->
      <div class="col-md-4">
        <h3><strong>Schritt 3</strong></h3>
        <ul>
          <li>Start der geplanten Modernisierungsmaßnahmen</li>
          <li>5&nbsp;% BEG-Bonus durch den iSFP sichern</li>
        </ul>
      </div>
    </div>
  </div>
</section>