<!-- Einleitung -->
<section class="py-5" aria-labelledby="ueberschrift-dach">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="ueberschrift-dach">FÖRDERGELDER ZUR Dachdämmung</h1>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Das Dach ist neben den Außenwänden der größte Bereich, in dem Wärmeverluste um bis zu 30&nbsp;% verringert werden können. Wer seine Heizkosten verringern und Energiekosten sparen möchte, der sollte eine Dämmung von Dach oder oberster Geschossdecke angehen. Für die fachgerechte Umsetzung der energieeffizienten Details können Hausbesitzer auf einen Energieeffizienz-Experten zurückgreifen.</p>
      </div>
    </div>
  </div>
</section>

<!-- Fördermöglichkeiten -->
<section class="bg-grey py-5" aria-labelledby="foerderarten-dach">
  <div class="container">
    <div class="row" id="foerderarten-dach">
      <div class="col-md-4">
        <h3><strong>Investitionszuschuss</strong></h3>
        <strong>15&nbsp;% Zuschuss</strong>
        <ul>
          <li>je Wohneinheit und Jahr</li>
          <li>förderfähige Ausgaben bis zu 30.000&nbsp;&euro;</li>
          <li>max. 4.500&nbsp;&euro; Zuschuss</li>
        </ul>
        <strong>20&nbsp;% Zuschuss</strong>
        <ul>
          <li>wenn ein individueller Sanierungsfahrplan vorliegt</li>
          <li>förderfähige Ausgaben bis zu 60.000&nbsp;&euro;</li>
          <li>max. 12.000&nbsp;&euro; Zuschuss</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>KfW-Ergänzungskredit</strong></h3>
        <ul>
          <li>zusätzlich zur bereits erteilten Zuschussförderung</li>
          <li>Kreditbetrag bis zu 120.000&nbsp;&euro; je Wohneinheit</li>
          <li>Zinssatz ab 0,01&nbsp;% (August 2024) mit tilgungsfreien Anlaufjahren</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h3><strong>Steuerliche Förderung</strong></h3>
        <ul>
          <li><strong>20&nbsp;% bis max. 40.000&nbsp;&euro;</strong> über 3 Jahre bei der Einkommenssteuer</li>
          <li>für private Eigentümer im selbst bewohnten Eigentum</li>
          <li>für Wohngebäude, die mindestens 10 Jahre alt sind</li>
        </ul>
      </div>
    </div>
  </div>
</section>

<!-- Energieberater -->
<section class="py-5" aria-labelledby="experten-dach">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="experten-dach">Mit Energie-Effizienz-Experten zur Förderung</h1>
        <h3>Für eine staatliche Förderung ist ein gelisteter Energieeffizienz-Experte vor Ort Pflicht.</h3>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>Die Sanierungsbegleitung unterstützt private Eigentümer von Ein- und Zweifamilienhäusern, die Ihre Immobilie energiesparend modernisieren möchten. Unabhängige Energieberater des Deutschen Energieberater-Netzwerkes DEN e.V. begleiten die Modernisierung von der Planung bis zur Umsetzung vor Ort und sorgen dadurch für hohe Qualität und hohe Energieeinsparung. Die Berater wissen ganz genau, welche Fördergelder bereit stehen und wie der maximale Zuschuss erzielt wird.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderservice -->
<section class="bg-grey py-5" aria-labelledby="foerderservice-dach">
  <div class="container">
    <div class="row" id="foerderservice-dach">

      <!-- Links -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/dachdaemmung.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbolbild Dachdämmung">
        </div>
        <h3><strong>Förderservice Dachdämmung</strong></h3>
        <p>Die auf eine Dämmung der Dachflächen zugeschnittene Sanierungsbegleitung ist sinnvoll, wenn Sie:</p>
        <ul>
          <li>Eigentümer eines Wohnhauses mit Bauantrag vor dem 1.2.2002 sind</li>
          <li>eine Dachdämmung planen und noch nicht begonnen haben</li>
          <li>staatliche Fördergelder der KfW nutzen wollen</li>
          <li>eine Begleitung durch einen Energieberater wünschen</li>
        </ul>
      </div>

      <!-- Mitte -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/kfw-antrag.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbol KfW Antrag">
        </div>
        <h3><strong>Für eine BEG-Förderung ist der Energieberater Pflicht</strong></h3>
        <p>Die Sanierungsbegleitung umfasst unter anderem:</p>
        <ul>
          <li>Beratung zu energetischen Mängeln und Maßnahmen</li>
          <li>Prüfung des Handwerkerangebots nach EnEV und KfW-Förderrichtlinien</li>
          <li>Sachverständigenbestätigung zum KfW-Antrag</li>
          <li>Ortstermin mit dem Fachhandwerker</li>
          <li>Stichprobenkontrollen vor Ort</li>
          <li>Beratung zur Mängelbeseitigung</li>
          <li>Prüfung der Schlussrechnungen</li>
          <li>Zusammenstellung der KfW-förderfähigen Kosten</li>
          <li>Sachverständigenbestätigung nach Durchführung</li>
        </ul>
        <div class="text-center mt-3">
          <a href="pix/checkliste_dach_keller.pdf" target="_blank" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Förderservice anfordern</strong>
          </a>
        </div>
      </div>

      <!-- Rechts -->
      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/energieberater.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Symbol Energieberater">
        </div>
        <h3><strong>Ihr Komplettpaket unverbindlich anfragen</strong></h3>
        <ul>
          <li><strong>individuelle Energieberatung</strong></li>
          <li><strong>Sanierungsfahrplan</strong></li>
          <li><strong>KfW-Fördermittel</strong></li>
        </ul>
        <strong>So funktioniert es:</strong>
        <p>Ihre Anfrage wird direkt an einen DEN-Energieberater in Ihrer Nähe übermittelt. Diese Vermittlung ist für Sie unverbindlich und kostenlos. Der Energieberater meldet sich innerhalb weniger Tage mit einem Angebot und zur Vereinbarung eines Vor-Ort-Termins bei Ihnen.</p>
      </div>
    </div>
  </div>
</section>

<!-- Förderbeispiel -->
<section class="py-5" aria-labelledby="beispiel-dach">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h1 id="beispiel-dach">Förderbeispiel</h1>
        <h3>Der tatsächliche Förderbetrag hängt von vielen Faktoren ab und berechnet sich individuell.</h3>
        <p>Je nach Haus, zu dämmender Dachfläche, Dachform, Dachaufbauten, Gauben oder Dachfenstern fallen sowohl der Modernisierungsumfang als auch die Kosten und Förderung unterschiedlich aus.</p>
      </div>
    </div>

    <div class="row mt-4" role="list" aria-label="Förderbeispiele Dachdämmung">
      
      <!-- Beispiel 1 -->
      <article class="col-md-4 border-end" role="listitem">
        <h3><strong>Dachdämmung</strong></h3>
        <p>In unserem Beispiel wird das Dach eines freistehenden Einfamilienhauses mit 120&nbsp;m² Wohnfläche gedämmt. Das Haus ist bisher unsaniert und wird mit einer Ölheizung beheizt.</p>
        <ul>
          <li>Kosten insgesamt: 55.000&nbsp;&euro;</li>
          <li>Sanierungsfahrplan: 1.640&nbsp;&euro;</li>
          <li>Förderservice BEG-Förderung: 399&nbsp;&euro;</li>
        </ul>
      </article>

      <!-- Beispiel 2 -->
      <article class="col-md-4" role="listitem">
        <h3><strong>4.500&nbsp;&euro; Zuschuss</strong></h3>
        <p>Die Kosten von 55.399&nbsp;&euro; werden mit 4.500&nbsp;&euro; bezuschusst.</p>
        <ul>
          <li>Sanierungszuschuss: 4.500&nbsp;&euro;</li>
          <li>Eigenanteil: 50.899&nbsp;&euro;</li>
        </ul>
      </article>

      <!-- Beispiel 3 -->
      <article class="col-md-4 border-start" role="listitem">
        <h3><strong>11.650&nbsp;&euro; Zuschuss mit Sanierungsfahrplan</strong></h3>
        <p>Die Kosten von 56.640&nbsp;&euro; werden mit 11.650&nbsp;&euro; bezuschusst.</p>
        <ul>
          <li>Sanierungszuschuss: 11.000&nbsp;&euro;</li>
          <li>Zuschuss Sanierungsfahrplan: 650&nbsp;&euro;</li>
          <li>Eigenanteil: 44.990&nbsp;&euro;</li>
        </ul>
        <p>Höherer Zuschuss für alle weiteren Maßnahmen an der Gebäudehülle durch den Sanierungsfahrplan.</p>
      </article>

    </div>
  </div>
</section>
