<!-- Einleitung -->
<section aria-labelledby="hauskauf-ueberschrift" class="py-5">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center text-uppercase">
        <h1 id="hauskauf-ueberschrift">Hauskauf mit Förderbonus</h1>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        <p>
Es muss nicht immer ein Neubau sein. Während neue Bebauungsgebiete oft in Ortsrandlage angesiedelt werden, sind Bestandsgebäude zentrumsnah und im Ort fest integriert. Kurze Wege und gute Infrastruktur sind nur zwei der vielseitigen Vorteile. Wer notwendige Um- und Ausbauten sowie anstehende Instandhaltungsarbeiten oder erforderliche energieeffiziente Sanierungsmaßnahmen in seine Kalkulation mit einbezieht, kann seinen Traum von Eigenheim auch im Altbau erfüllen. Neben Fördermöglichkeiten von Bund und Ländern, sollte auch nach Förderungen im eigenen Ort geschaut werden. &bdquo;Alt-kauft-Neu&ldquo; Programme, Städtebau- und Dorferneuerungsprogramme bieten je nach Wohnort lohnende Förderchancen.
</p>
      </div>
    </div>
  </div>
</section>

<!-- Programme im Überblick -->
<section aria-labelledby="hauskauf-programme" class="bg-grey py-5" role="region">
  <div class="container">
    <div class="row" role="list" aria-label="Förderprogramme Hauskauf">

      <!-- Wohneigentumsprogramm -->
      <article class="col-md-4" role="listitem">
        <div class="text-center">
          <img src="pix/immokauf.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon Immokauf" />
        </div>
        <h3 class="text-center"><strong>Wohneigentums-Programm</strong></h3>
        <p><strong>Bis zu 100.000 &euro; des neuen Eigenheims über einen KfW-Förderkredit finanzieren.</strong> Gefördert wird das Wohneigentum. Erfüllt der Altbau zusätzlich die Kriterien eines KfW-Effizienzhauses, können beide Förderprogramme genutzt werden.</p>
        <p><strong>Mögliche Finanzierung der:</strong></p>
        <ul>
          <li>Kaufpreis</li>
          <li>Kosten für Instand­setzung, Umbau und Modernisierung</li>
          <li>Nebenkosten wie die Notar- oder Makler­gebühren und die Grunderwerb­steuer</li>
        </ul>
      </article>

      <!-- Effizienzhaus-Kauf -->
      <article class="col-md-4" role="listitem">
        <div class="text-center">
          <img src="pix/effizienzhaus.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon Effizienzhaus" />
        </div>
        <h3 class="text-center"><strong>Kauf von energieeffizient saniertem Wohnraum</strong></h3>
        <p>Für den Kauf eines frisch sanierten Effizienzhauses, können bis zu 150.000 &euro; der förderfähigen Kosten über einen Förderkredit der Bundesförderung für effiziente Gebäude finanziert werden.
Je nach Effizienzhausstandard wird ein Teil des Kreditbetrags als Tilgungszuschuss erlassen.</p>
      </article>

      <!-- Barrierefreier Kauf -->
      <article class="col-md-4" role="listitem">
        <div class="text-center">
          <img src="pix/sanierung.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" alt="Icon Sanierung" />
        </div>
        <h3 class="text-center"><strong>Der Kauf von barrierefrei saniertem Wohnraum</strong></h3>
        <p>Der Kauf einer gerade erst neu umgebauten Immobilie im Ersterwerb kann über das KfW-Programm Altersgerecht Umbauen finanziert werden.
Die Kosten für die barrierereduzierenden Maßnahmen müssen dazu im Kaufvertrag gesondert ausgewiesen werden.</p>
      </article>

    </div>

    <div class="row mt-5">
      <div class="col-md-12 text-center">
        <a href="/Foerdergeld-Suche-Immobilien#suche" class="btn btn-warning" aria-label="Zur Fördergeld-Suche">
          <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zur Fördergeld-Suche</strong>
        </a>
      </div>
    </div>
  </div>
</section>

<!-- Beispiel Finanzierung Hauskauf -->
<section aria-labelledby="hauskauf-beispiel" class="py-5" role="region">
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <h2 id="hauskauf-beispiel">Förderbeispiel: Hauskauf</h2>
        <h3>Ein altes Haus verwandelt sich in ein Zuhause zum Wohlfühlen</h3>
        <p>Niedrige Energiekosten, helle Räume, gutes Wohnklima: Mit geförderten Umbaumaßnahmen wird auch ein Haus aus den 70er Jahren genauso, wie es sich die Bauherren wünschen.</p>
      </div>
    </div>

    <div class="row mt-4" role="list" aria-label="Finanzierungsbeispiel Hauskauf">

      <!-- Sanierungskosten -->
      <article class="col-md-4" role="listitem">
        <h4><strong>Sanierungskosten</strong></h4>
        <p>Insgesamt: <strong>170.000 &euro;</strong></p>
        <ul>
          <li>140.000 &euro; energetische Sanierung zum Effizienzhaus 85 (Dämmung Wände und Dach, neue Fenster, neue Heizung)</li>
          <li>25.000 &euro; barrierefreie Bad-Modernisierung</li>
          <li>5.000 &euro; für Fachplanung und Baubegleitung</li>
        </ul>
      </article>

      <!-- Förderdarlehen mit Linien -->
      <article class="col-md-4 article-divider" role="listitem">
        <h4><strong>Förderdarlehen</strong></h4>
        <p>Insgesamt: <strong>bis zu 165.000 &euro;</strong></p>
        <ul>
          <li>140.000 &euro; BEG-Kredit Effizienzhaus 85 EE-Klasse</li>
          <li>5.000 &euro; Kreditbetrag für Fachplanung und Baubegleitung</li>
          <li>25.000 &euro; KfW-Kredit Altersgerecht Umbauen</li>
        </ul>
      </article>

      <!-- Tilgungszuschüsse -->
      <article class="col-md-4" role="listitem">
        <h4><strong>Tilgungszuschüsse</strong></h4>
        <p>Insgesamt: <strong>bis zu 16.500 &euro;</strong></p>
        <ul>
          <li>14.000 &euro; Tilgungszuschuss für den BEG-Kredit</li>
          <li>2.500 &euro; Tilgungszuschuss für Fachplanung und Baubegleitung</li>
        </ul>
      </article>

    </div>
  </div>
</section>
