<!-- Energieberatung anfordern -->
<section class="py-5" aria-labelledby="energieberatung-ueberschrift">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center">
        <h1 id="energieberatung-ueberschrift" class="text-uppercase">Energieberatung unverbindlich anfordern</h1>
        <h3>Einen professionellen Energieberater vom Deutschen Energieberater-Netzwerk buchen.</h3>
      </div>
    </div>

    <div class="row">
      <div class="col-12">
        <p>Wenn es um Fördermittel für energieeffizientes Bauen und Modernisieren geht, ist die Einbeziehung eines Energieeffizienz-Experten sinnvoll und mitunter sogar Pflicht. Damit Sie Ihre Vorhaben sowohl mit der bestmöglichen Energieeinsparung als auch mit der maximalen Förderung umsetzen können, arbeiten wir mit unabhängigen Energieberatern des Deutschen Energie-Berater-Netzwerks (DEN e.V.) zusammen.</p>
      </div>
    </div>

    <!-- Kachelreihe 1 -->
    <div class="row mt-4">
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Initialberatung" title="Initialberatung">
              <img src="pix/initialberatung-400x400.png" class="img-responsive hover-effect" alt="Initialberatung">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Initialberatung" title="Initialberatung">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;Initialberatung
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Sanierungsfahrplan" title="Individueller Sanierungsfahrplan">
              <img src="pix/bafa-vor-ort-beratung-400x400.png" class="img-responsive hover-effect" alt="Individueller Sanierungsfahrplan">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Sanierungsfahrplan" title="Individueller Sanierungsfahrplan">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;Individueller Sanierungsfahrplan
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Modernisierung" title="KfW-Nachweise">
              <img src="pix/kfw-nachweis-400x400.png" class="img-responsive hover-effect" alt="KfW-Nachweise">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Modernisierung" title="KfW-Nachweise">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;KfW-Nachweise
            </a>
          </div>
        </div>
      </div>
    </div>

    <!-- Kachelreihe 2 -->
    <div class="row mt-4">
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Energieausweis" title="Energieausweis">
              <img src="pix/energieausweis-400x400.png" class="img-responsive hover-effect" alt="Energieausweis">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Energieausweis" title="Energieausweis">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;Energieausweis
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Thermografie" title="Thermografie">
              <img src="pix/thermografie-400x400.png" class="img-responsive hover-effect" alt="Thermografie">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Thermografie" title="Thermografie">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;Thermografie
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="panel panel-primary">
          <div class="panel-body p-0 overflow-hidden">
            <a href="Luftdichtheitsmessung" title="Luftdichtheitstest">
              <img src="pix/blower-door-test-400x400.png" class="img-responsive hover-effect" alt="Luftdichtheitstest">
            </a>
          </div>
          <div class="panel-footer text-center">
            <a href="Luftdichtheitsmessung" title="Luftdichtheitsmessung">
              <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;Luftdichtheitstest
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Schritte Energieberateranfrage -->
<section class="py-5" aria-labelledby="schritte-ueberschrift">
  <div class="container">
    <h2 id="schritte-ueberschrift" class="text-center">So funktioniert Ihre Anfrage</h2>
    <div class="row text-center mt-4">
      <div class="col-md-4 border-end">
        <h3><strong>Schritt 1</strong></h3>
        <p>Wählen Sie je nach geplanter Maßnahme die passende Dienstleistung aus und fragen Sie unverbindlich einen Energieberater an.</p>
      </div>
      <div class="col-md-4">
        <h3><strong>Schritt 2</strong></h3>
        <p>Ihre Anfrage wird direkt an einen DEN-Energieberater in Ihrer Nähe übermittelt. Diese Vermittlung ist für Sie unverbindlich und kostenlos.</p>
      </div>
      <div class="col-md-4 border-start">
        <h3><strong>Schritt 3</strong></h3>
        <p>Der Energieberater wird sich innerhalb weniger Tage bei Ihnen melden, offene Fragen klären, ein Angebot unterbreiten und einen Vor-Ort-Termin vereinbaren.</p>
      </div>
    </div>
  </div>
</section>

<!-- Warum Energieberater -->
<section class="bg-grey py-5" aria-labelledby="warum-energieberater">
  <div class="container">
    <h2 id="warum-energieberater" class="text-center">Wozu brauche ich einen Energieberater</h2>
    <h3 class="text-center">Bei umfangreichen Sanierungen lohnt sich die Vor-Ort-Beratung durch unabhängige Experten.</h3>
    <div class="row mt-4">
      <div class="col-md-4">
        <h4><strong>Einsparoptionen</strong></h4>
        <p>Der Energieberater bietet eine verlässliche Strategie für:</p>
        <ul>
          <li>gezielte Einzelmaßnahmen</li>
          <li>mehrere Maßnahmen in richtiger Reihenfolge</li>
          <li>komplette Modernisierung in einem Zug</li>
        </ul>
        <p>Auch anstehende Instandsetzungen werden mit Effizienzmaßnahmen kombiniert.</p>
      </div>
      <div class="col-md-4">
        <h4><strong>Entscheidungshilfe</strong></h4>
        <p>Die Beratung klärt:</p>
        <ul>
          <li>Was ist sinnvoll?</li>
          <li>Was ist machbar?</li>
          <li>Was ist finanzierbar?</li>
          <li>Womit beginnt man am besten?</li>
        </ul>
      </div>
      <div class="col-md-4">
        <h4><strong>BEG-Förderung</strong></h4>
        <p><strong>Ein Energieberater spart nicht nur Energie und Kosten, sondern bringt sogar Fördergeld mit.</strong></p>
        <p>Ohne Fachplanung und Baubegleitung durch einen gelisteten Energieeffizienz-Experten gibt es keine BEG-Förderung.</p>
      </div>
    </div>
  </div>
</section>

<!-- Qualifikation Energieberater -->
<section class="py-5" aria-labelledby="qualifikation-energieberater">
  <div class="container">
    <h2 id="qualifikation-energieberater" class="text-center">Ist jeder Energieberater gleichermaßen qualifiziert?</h2>
    <h3 class="text-center">Energieberater ist nicht gleich Energieberater</h3>
    <div class="row mt-4">
      <div class="col-12">
        <p>Die Berufsbezeichnung „Energieberater“ ist in Deutschland nicht geschützt. Das kann zu Qualitäts- und Neutralitätsproblemen führen. Für neutrale Sanierungsempfehlungen, aussagekräftige Energieausweise und Fördergelder sollten Sie sich an qualifizierte Experten wenden.</p>
        <p>Das Deutsche Energieberater Netzwerk (DEN e.V.) bietet mit über 700 Ingenieurbüros bundesweit versierte Berater. Leistungen sind transparent ausgepreist und detailliert formuliert. Eine webbasierte Beratervermittlung sorgt für schnelle Rückmeldung.</p>
      </div>
    </div>

    <!-- Drei Info-Boxen mit Symbol -->
    <div class="row mt-5">
      <div class="col-md-4 border-end">
        <div class="text-center mb-3">
          <img src="pix/energieberater.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" style="max-width: 60%;" alt="Energieberater Symbol">
        </div>
        <h4 class="text-center">Energieberatung Wohngebäude</h4>
        <p>Zuschuss von 80&nbsp;% des Honorars:</p>
        <ul>
          <li>max. 1.300&nbsp;&euro; bei Ein-/Zweifamilienhäusern</li>
          <li>max. 1.700&nbsp;&euro; bei Mehrfamilienhäusern</li>
          <li>max. 500&nbsp;&euro; für Erläuterung in WEG-Versammlungen</li>
        </ul>
        <div class="text-center mt-3">
          <a href="BAFA-Vor-Ort-Beratung" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zur Energieberatung Wohngebäude</strong>
          </a>
        </div>
      </div>

      <div class="col-md-4">
        <div class="text-center mb-3">
          <img src="pix/sanierung.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" style="max-width: 60%;" alt="Sanierung Symbol">
        </div>
        <h4 class="text-center">Sanieren mit BEG-Förderung</h4>
        <p>Ein Experte aus der Energieeffizienz-Expertenliste wird benötigt für:</p>
        <ul>
          <li>Bestätigung zum Antrag</li>
          <li>Bestätigung nach Durchführung</li>
        </ul>
        <div class="text-center mt-3">
          <a href="Modernisierung" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zur Sanierungsbegleitung</strong>
          </a>
        </div>
      </div>

      <div class="col-md-4 border-start">
        <div class="text-center mb-3">
          <img src="pix/kfw-antrag.png" class="img-fluid rounded-circle d-block mx-auto"  style="max-width: 50%;" style="max-width: 60%;" alt="KfW Antrag Symbol">
        </div>
        <h4 class="text-center">Zuschuss Baubegleitung</h4>
        <p>Die KfW übernimmt:</p>
        <ul>
          <li>50&nbsp;% der Kosten für die Baubegleitung</li>
          <li>max. 5.000&nbsp;&euro; bei Ein-/Zweifamilienhäusern</li>
        </ul>
        <div class="text-center mt-3">
          <a href="Modernisierung" class="btn btn-warning">
            <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<strong>Zum KfW/BEG-Nachweis</strong>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>
